import sys
sys.setrecursionlimit(300000)
input = sys.stdin.readline
class TrieNode:
    __slots__ = ("children", "end")
    def __init__(self):
        self.children = {}
        self.end = None 
def solve():
    n = int(input())
    a = list(map(int, input().split()))
    nums = [str(x) for x in a]
    root = TrieNode()
    for s in nums:
        node = root
        for ch in s:
            if ch not in node.children:
                node.children[ch] = TrieNode()
            node = node.children[ch]
        node.end = s
    def dfs(node):
        sets = []
        for child in node.children.values():
            sets.extend(dfs(child))
        if node.end is not None:
            if not sets:
                sets = [[node.end]]
            else:
                sets[0].append(node.end)
        return sets
    groups = dfs(root)
    print(len(groups))
    for g in groups:
        print(len(g))
        print(' '.join(g))
if __name__ == "__main__":
    solve()